function init() {
	const menuBtn = document.querySelector('.menu-btn');
	const nav = document.querySelector('.nav');
	const navItem = document.querySelectorAll('.nav li');
	const expand = document.querySelectorAll('.expand');
	const closeBtn = document.querySelector('.close-btn');
	const imgViewer = document.querySelector('.img-viewer');
	const imgViewerImage = document.querySelector('.img-viewer img')
	const imgViewerOverlay = document.querySelector('.img-viewer-overlay');

	const navBarToggle = function () {
	  menuBtn.classList.toggle('active');
	  nav.classList.toggle('active');
	}
	
	if (!menuBtn.dataset.init) {
		for (let i = 0; i < navItem.length; i++) {
		  navItem[i].addEventListener('click', navBarToggle)
		}

		menuBtn.addEventListener('click', navBarToggle);
		menuBtn.dataset.init = true;
	}

	if (!imgViewer.dataset.init) {
		for (let i = 0; i < expand.length; i++) {
		  expand[i].addEventListener('click', function () {
			imgViewerImage.src = this.previousElementSibling.src
			imgViewer.classList.add('active');
			imgViewerOverlay.classList.add('active');
		  });
		}

		const rmImgViewer = function () {
		  imgViewer.classList.remove('active');
		  imgViewerOverlay.classList.remove('active');
		}

		closeBtn.addEventListener('click', rmImgViewer);
		imgViewerOverlay.addEventListener('click', rmImgViewer);
		imgViewer.dataset.init = true;
	}
}

init();

function rallyAfterPageLoad() {
	if(document.querySelector("[data-v-component-product]")) {
		productPage();
	}
	
	if(document.querySelector("[data-v-cart-page]")) {
		//cartPage();
	}
	//get navbar for sticky
	navbar = document.getElementsByClassName("navbar")[0];

	init();
}

window.VvvebTheme = window.VvvebTheme ?? {ajax:{}};
window.VvvebApp = window.VvvebApp ?? {};
VvvebTheme.ajax.afterLoad  = rallyAfterPageLoad;

