'use strict';



/**
 * add event on multiple elements
 */

const addEventOnElements = function (elem, type, callback) {
  for (let i = 0, len = elem.length; i < len; i++) {
    elem[i].addEventListener(type, callback);
  }
}



/**
 * LOADING
 */
/*
const loadingElement = document.querySelector("[data-loading-container]");

window.addEventListener("load", function () {
  loadingElement.classList.add("loaded");
  document.body.classList.add("loaded");
});

*/

let revealElements = document.querySelectorAll("[data-reveal]");

function init() {

	/**
	 * MOBILE NAVBAR TOGGLE
	 */

	const navbarHeader = document.querySelector("[data-navbar]");
	const navTogglers = document.querySelectorAll("[data-nav-toggler]");
	const navbarLinks = document.querySelectorAll(".navbar-link");
	const overlay = document.querySelector("[data-overlay]");

	const toggleNavbar = function () {
	  navbarHeader.classList.toggle("active");
	  overlay.classList.toggle("active");
	  document.body.classList.toggle("active");
	}


	const closeNavbar = function () {
	  navbarHeader.classList.remove("active");
	  overlay.classList.remove("active");
	  document.body.classList.remove("active");
	}


	/**
	 * HEADER
	 */

	// header will be active after scroll 200px of window

	const header = document.querySelector("[data-header]");

	const headerActive = function () {
	  window.scrollY > 200 ? header.classList.add("active")
		: header.classList.remove("active");
	}

	if (!navbarHeader.dataset.init) {
		addEventOnElements(navbarLinks, "click", closeNavbar);
		addEventOnElements(navTogglers, "click", toggleNavbar);
		window.addEventListener("scroll", headerActive);

		navbarHeader.dataset.init = true;
	}

	/**
	 * SCROLL REVEAL
	 */
	 revealElements = document.querySelectorAll("[data-reveal]");
}


	const scrollReveal = function () {
		console.log('scrollReveal');
		
	  for (let i = 0, len = revealElements.length; i < len; i++) {
		if (revealElements[i].getBoundingClientRect().top < window.innerHeight / 1.2) {
		  revealElements[i].classList.add("revealed");
		}
	  }
	}

	window.addEventListener("scroll", scrollReveal);
	window.addEventListener("load", scrollReveal);



init();

function fastEatAfterPageLoad() {
	if(document.querySelector("[data-v-component-product]")) {
		productPage();
	}
	
	if(document.querySelector("[data-v-cart-page]")) {
		//cartPage();
	}
	//get navbar for sticky
	navbar = document.getElementsByClassName("navbar")[0];

	init();
	scrollReveal();
}

window.VvvebTheme = window.VvvebTheme ?? {ajax:{}};
window.VvvebApp = window.VvvebApp ?? {};
VvvebTheme.ajax.afterLoad  = fastEatAfterPageLoad;

