<?php

/**
 * Vvveb
 *
 * Copyright (C) 2022  Ziadin Givan
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

namespace Vvveb\Plugins\Newsletter\Controller;

use Vvveb\Controller\Listing;

class NewsletterList extends Listing {
	protected $type = 'newsletter_list';

	protected $modelName = 'Plugins\Newsletter\newsletter_list';

	//protected $model = 'newsletter_list';

	protected $controller = 'newsletter-mail';

	protected $list = 'newsletter_list';

	protected $listController = 'lists';

	protected $module = 'plugins/newsletter';

	function index() {
		parent::index();

		//expand fields in the json
		if ($this->view->newsletter_list) {
			foreach ($this->view->newsletter_list as &$newsletter_list) {
				$data = json_decode($newsletter_list['data'] ?? '{}', true);

				if (is_array($data)) {
					$newsletter_list += $data;
				}
			}
		}
	}
}
