-- newsletter_lists

	-- Get one newsletter_list

	CREATE PROCEDURE get(
		IN newsletter_list_id INT,
		IN name CHAR,
		OUT fetch_row, 
	)
	BEGIN
		-- newsletter_list
		SELECT *
			FROM newsletter_list as _ -- (underscore) _ means that data will be kept in main array
			
			WHERE 1 = 1 
			
			@IF isset(:name) && !empty(:name)
			THEN
				AND _.name = :name
			END @IF	
					
			@IF isset(:newsletter_list_id) && !empty(:newsletter_list_id)
			THEN
				 _.newsletter_list_id = :newsletter_list_id 
			END @IF			
			
		LIMIT 1;
	END

	-- Edit newsletter_list

	CREATE PROCEDURE edit(
		IN newsletter_list ARRAY,
		IN newsletter_list_id INT,
		OUT affected_rows
	)
	BEGIN
		-- allow only table fields and set defaults for missing values
		@FILTER(:newsletter_list, newsletter_list)
		
		UPDATE newsletter_list 
			
			SET @LIST(:newsletter_list) 
			
		WHERE newsletter_list_id = :newsletter_list_id
	END	

	-- Add new newsletter_list

	CREATE PROCEDURE add(
		IN newsletter_list ARRAY,
		OUT insert_id
	)
	BEGIN
		
		-- allow only table fields and set defaults for missing values
		:newsletter_list  = @FILTER(:newsletter_list, newsletter_list)

		INSERT INTO newsletter_list 
		
			( @KEYS(:newsletter_list) )
			
		VALUES ( :newsletter_list );			

	END


	-- Get all newsletter_lists 

	CREATE PROCEDURE getAll(

		-- variables
		IN  language_id INT,
		IN  user_group_id INT,
		IN  site_id INT,
		IN  search CHAR,
		
		-- pagination
		IN  start INT,
		IN  limit INT,
			
		-- return array of newsletter_lists for newsletter_lists query
		OUT fetch_all,
		-- return newsletter_lists count for count query
		OUT fetch_one,
	)
	BEGIN

		SELECT * 
			FROM newsletter_list 
		ORDER BY newsletter_list_id DESC
			
		LIMIT :limit OFFSET :start;
		
		SELECT count(*) FROM (
			
			@SQL_COUNT(newsletter_list.newsletter_list_id, newsletter_list) -- this takes previous query removes limit and replaces select columns with parameter product_id
			
		) as count;


	END


	-- Delete newsletter_list

	CREATE PROCEDURE delete(
		IN  newsletter_list_id ARRAY,
		OUT affected_rows
	)
	BEGIN

		DELETE FROM newsletter_list WHERE newsletter_list_id IN (:newsletter_list_id)
	 
	END

	-- Get number of newsletter_lists with specified status

	CREATE PROCEDURE getStatusCount(
		IN status INT,
		OUT fetch_row, 
	)
	BEGIN
		-- newsletter_list
		SELECT count(*) as count
			FROM newsletter_list as _ -- (underscore) _ means that data will be kept in main array
		WHERE status = :status LIMIT 1;
	END
